### 概述

**Instaguard 设备智能看护诊断系统**
Instaguard-设备智能看护诊断系统，是集看护、诊断、管理于一体的工业数字化、智能化监测管理工具。通过多维数据接入IotHub完成全息数据接入整合，使用预训练大模型与工业知识图谱的Metafacture完成AI智能预测于精准故障定位，最终通过Fastkit向客户系统、Instaguard前端展示系统提供多种数据协议进行融合、呈现。为客户提供数据概览、实时看板、机组台账、设备档案、诊断图谱、异常诊断历史、看护报告、组织设备树等功能。让客户随时随地掌握设备运转状态，及时发现设备异常及故障原因，降低意外停机风险与损失，提高生产效率与管理效率。Instaguard采用微服务架构模式，按照系统功能模块、数据处理流程拆分为多个微服务，并对用户实现功能自选服务。融合轻量化容器技术实现微服务的统一部署、资源调度优化、自动化CI/CD、用户无感升级。Instaguard平台存储采用关系数据库、NoSQL、文件系统混合架构模式实现对结构化数据、非结构化数据、半结构化数据进行多源异构数据存储。对用户提供web及多种数据输出协议。系统可支持通过Mqtt、消息队列订阅推送、Restful API等多种途径进行多维数据输入。同时支持标准云端API、OPC SERVER接口等多种协议数据输出，可将系统功能封装集成至用户指定平台中。


 

**下表概述了Instaguard的各个产品组件**

| **产品组件** | **描述说明**                                                                                                  |
| -------- | --------------------------------------------------------------------------------------------------------- |
| 智能看护大屏   | 支持多维度机组数据可视化、预警通知集成及组织级健康统计，实现设备运维的快速洞察与决策支持。                                                             |
| 工艺概览     | 支持设备上下游流程的实时数据集成与交互式状态呈现，赋能工艺调优与运维决策的直观化、数据驱动化。                                                           |
| 智能机组看护   | 支持通过智能看板实现机组健康状态全景可视化，结合机组与设备台账的层级化管理，形成覆盖“机组-设备-测点”的全链条运维视图，赋能设备健康评估、故障诊断及运行优化决策。                        |
| 智能机组诊断   | 支持通过多视图图谱分析实现设备状态深度诊断，结合异常历史记录追踪、AI/人工诊断报告管理及IOT硬件状态监控，形成覆盖“数据洞察-异常预警-报告生成-硬件联动”的闭环运维体系，提升设备健康评估效率与决策精准度。 |
| 智能报表管理   | 支持设备运行时长统计、故障预警监控、能耗效率分析及组织级数据聚合，支持自定义查询条件与数据导出，助力运维决策优化与业务效能提升。                                          |
| 系统管理     | 支持组织树形结构调整、用户全生命周期管理、角色权限动态分配及消息推送策略定制，实现平台资源的安全合规访问与业务信息的高效触达。                                           |




**下表概述了IOTHub的各个产品组件**

| **产品组件** | **描述说明**                                                                                                             |
| -------- | -------------------------------------------------------------------------------------------------------------------- |
| IOTHub   | 支持通过标准化编码规则实现设备快速准入，具备设备绑定/解绑、参数配置、采集策略下发等核心能力，支持设备状态监控、数据链路维护及多协议适配，同时建立严格的设备删除保护机制，确保数据完整性。                        |
| 组态管理     | 支持机组全生命周期操作与多维度测点配置，实现基于IOT编号、硬件类型、组织架构的多条件测点检索，确保设备参数与业务数据的精准关联及动态维护。                                               |
| 算法管理     | 支持多类型算法的创建、版本控制、机组绑定及工程化部署，实现算法流与机组级业务场景的动态关联，具备任务执行监控、日志追溯、输入输出数据闭环管理功能，保障算法模型从研发到工业现场的高效落地与精准运行。                   |
| 开发接入管理   | 支持对接方全生命周期管理、接口资源分配与设备数据路由配置，实现基于API的定制化数据交互、调用频次控制及操作审计，确保外部系统与智能诊断平台的高效、安全集成。                                      |
| 字典管理     | 支持轴承参数、采集策略、产品属性等核心数据的标准化定义与动态维护，通过字典管理实现可扩展属性库的灵活配置，结合机组及设备模型库的模板化设计，实现设备类型、测点配置、预警规则的统一建模与复用，确保设备全生命周期数据的一致性与高效管理。 |
| 账户管理     | 支持用户生命周期操作、角色权限精细化分配、部门层级动态维护，实现系统资源的合规访问控制与组织结构的灵活扩展，保障平台操作安全与协作效率。                                                 

---
Instaguard快速操作指南

[![](https://resource.helplook.net/docker_production/3648ne/article/spXmBDEQ/686dca5c17c6a.png)](https://www.bilibili.com/video/BV1NsEXzQEuf?t=376.9)